<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    ShowUserDetail()
  ===================================================*/

  function ShowUserDetail() {

    // vars global configuration
    global $theme_path, $theme_name, $category_separator;

    // vars url & form
    global $u;

    // vars messages
    global $msg;

    // vars template
    global $biography, $name, $username, $category, $icq, $aol, $yahoo, $interest, $location, $occupation, $homepage,
             $date;

    $username  = $u;

    $users_obj = new clsUsers;
    $users_obj->table_name  = "idx_users";
    $users_obj->date_format = $msg["10301"];
    $detail                 = $users_obj->GetUserDetail($username);
    
    $biography              = stripslashes($detail["biography"]);
    $name                   = $detail["name"];
    $icq                    = $detail["icq"];
    $aol                    = $detail["aol"];
    $yahoo                  = $detail["yahoo"];
    $interest               = $detail["interest"];
    $location               = $detail["location"];
    $occupation             = $detail["occupation"];
    $homepage               = $detail["homepage"];
    $date                   = $detail["date"];

    if ($homepage == 'http://')
      $homepage = '';
    
    $links_obj = new clsLink;
    $links_obj->table_name          = "idx_link";
    $links_obj->category_table_name = "idx_category";
    $links_obj->user_table_name     = "idx_users";
    $links_obj->editor_table_name   = "idx_editor";

    $category_obj = new clsCategory;
    $category_obj->table_name      = "idx_category";
    $category_obj->link_table_name = "idx_link";
    $category_obj->separator       = $category_separator;
    $categories                    = $links_obj->GetEditorCategory($username);

    while (list(, $v) = @each($categories)) {
      $category .= "<img src=\"themes/$theme_name/images/folder4.gif\" align=\"top\" alt=\"\" /> " 
        . $category_obj->GetCategoryPath($v, TRUE) . "<br />";
    }

    DisplayTemplate($theme_path . "user_detail.html",
                    "\$biography,\$name,\$username,\$category,"
                      . "\$icq,\$aol,\$yahoo,\$interest,\$location,\$occupation,\$homepage,\$date");
  }


  /*===================================================
    main
  ===================================================*/

  include "application.php";

  RunPreFilter(__FILE__);

  ShowUserDetail();

  RunPostFilter(__FILE__);

?>